ALTER TABLE Prod_Familias ADD	Activo					TINYINT,
								Flag_Valida_Sala		TINYINT,
								Flag_Valida_Horarios	TINYINT,
								Flag_Horarios_Comunes	TINYINT, /*Para todos los Productos de la familia*/
								Flag_Salas_Comunes		TINYINT,
								Flag_Asistencia			TINYINT,
								Fecha_Desde				DATETIME,
								Fecha_Hasta				DATETIME,
								Cupo					SMALLINT /*Por Programa*/
GO

/*======================================================================================================================*/

CREATE TABLE Prod_Familias_Horarios
(
Id_Prod_Familia_Horario	INT	IDENTITY(1,1),
Id_Familia				INT NOT NULL,
Activo					TINYINT NULL,
Cupo					SMALLINT NULL,	/*Por Horario, para Flag_Horarios_Comunes = 1 (de Prod_Familias)*/
Dia						TINYINT NULL,	/*Dias: 0=Domingo | 1=Lunes | 2=Martes | 3=Miercoles | 4=Jueves | 5=Viernes | 6=Sabado*/
Hora_Desde				DATETIME NULL,
Hora_Hasta				DATETIME NULL
)
GO

ALTER TABLE Prod_Familias_Horarios ADD CONSTRAINT PK_PFHOR_PorId PRIMARY KEY (Id_Prod_Familia_Horario)
GO

CREATE UNIQUE INDEX IX_PFHOR_PorId_Familia ON Prod_Familias_Horarios (Id_Familia, Dia, Hora_Desde, Hora_Hasta)
GO

ALTER TABLE Prod_Familias_Horarios ADD CONSTRAINT FK_PFHOR_Prod_Familias FOREIGN KEY (Id_Familia) REFERENCES Prod_Familias (Id_Familia)
GO

/*======================================================================================================================*/

CREATE TABLE Prod_Horarios
(
Id_Prod_Horario			INT	IDENTITY(1,1),
Id_Producto				VARCHAR(14) NOT NULL, /*Si Flag_Horarios_Comunes(Prod_Familias) = 1 entonces Id_Producto = '', si Flag_Horarios_Comunes(Prod_Familias) = 0 tiene que ir el Id_Producto*/
Id_Prod_Familia_Horario INT NOT NULL,
Cupo					SMALLINT NULL, /*Por Horario, para Flag_Horarios_Comunes = 0 (de Prod_Familias)*/
)
GO

ALTER TABLE Prod_Horarios ADD CONSTRAINT PK_PRHOR_PorId PRIMARY KEY (Id_Prod_Horario)
GO

CREATE UNIQUE INDEX IX_PRHOR_PorProduc_Horario ON Prod_Horarios (Id_Producto, Id_Prod_Familia_Horario)
GO

ALTER TABLE Prod_Horarios ADD CONSTRAINT FK_PRHOR_Productos FOREIGN KEY (Id_Producto) REFERENCES Productos (Id_Producto)
GO

ALTER TABLE Prod_Horarios ADD CONSTRAINT FK_PRHOR_Prod_Familias_Horarios FOREIGN KEY (Id_Prod_Familia_Horario) REFERENCES Prod_Familias_Horarios (Id_Prod_Familia_Horario)
GO

/*======================================================================================================================*/

CREATE TABLE Prod_Familias_Salas
(
Id_Prod_Familia_Sala	INT	IDENTITY(1,1),
Activo					TINYINT,
Id_Familia				INT NOT NULL,
Descripcion				VARCHAR(100) NOT NULL,
Cupo					SMALLINT NULL, /*Por Sala, para Flag_Horarios_Comunes = 1 (de Prod_Familias)*/
Edad_Min				TINYINT,	
Edad_Max				TINYINT,
Sexo					CHAR(1)
)
GO

ALTER TABLE Prod_Familias_Salas ADD CONSTRAINT PK_PFSAL_PorId PRIMARY KEY (Id_Prod_Familia_Sala)
GO

CREATE UNIQUE INDEX IX_PFSAL_PorId_Familia ON Prod_Familias_Salas (Id_Familia, Edad_Min, Edad_Max, Sexo)
GO

ALTER TABLE Prod_Familias_Salas ADD CONSTRAINT FK_PFSAL_Prod_Familias FOREIGN KEY (Id_Familia) REFERENCES Prod_Familias (Id_Familia)
GO

/*======================================================================================================================*/

CREATE TABLE Prod_Salas
(
Id_Prod_Sala			INT IDENTITY(1,1),
Id_Prod_Familia_Sala	INT	NOT NULL,
Id_Producto				VARCHAR(14) NOT NULL,
Cupo					SMALLINT NULL /*Por Sala, para Flag_Horarios_Comunes = 0 (de Prod_Familias)*/
)
GO

ALTER TABLE Prod_Salas ADD CONSTRAINT PK_PRSAL_PorId PRIMARY KEY (Id_Prod_Sala)
GO

CREATE UNIQUE INDEX IX_PRSAL_PorId_Familia_Sala ON Prod_Salas (Id_Prod_Familia_Sala, Id_Producto)
GO

ALTER TABLE Prod_Salas ADD CONSTRAINT FK_PRSAL_Prod_Familias_Salas FOREIGN KEY (Id_Prod_Familia_Sala) REFERENCES Prod_Familias_Salas (Id_Prod_Familia_Sala)
GO

ALTER TABLE Prod_Salas ADD CONSTRAINT FK_PRSAL_Productos FOREIGN KEY (Id_Producto) REFERENCES Productos (Id_Producto)
GO

/*======================================================================================================================*/

CREATE TABLE Prod_Familias_Horarios_Salas
(
Id_Prod_Familia_Horario_Sala	INT IDENTITY(1,1),
Id_Prod_Familia_Horario			INT NOT NULL,
Id_Prod_Familia_Sala			INT NOT NULL,
Cupo							SMALLINT NULL /*Por Horario, Sala*/
)

ALTER TABLE Prod_Familias_Horarios_Salas ADD CONSTRAINT PK_PFHORSAL_PorId PRIMARY KEY (Id_Prod_Familia_Horario_Sala)
GO

CREATE UNIQUE INDEX IX_PFHORSAL_PorId_Familia_Horario_Sala ON Prod_Familias_Horarios_Salas (Id_Prod_Familia_Horario, Id_Prod_Familia_Sala)
GO

ALTER TABLE Prod_Familias_Horarios_Salas ADD CONSTRAINT FK_PFHORSAL_Prod_Familias_Horarios FOREIGN KEY (Id_Prod_Familia_Horario) REFERENCES Prod_Familias_Horarios (Id_Prod_Familia_Horario)
GO

ALTER TABLE Prod_Familias_Horarios_Salas ADD CONSTRAINT FK_PFHORSAL_Prod_Familias_Salas FOREIGN KEY (Id_Prod_Familia_Sala) REFERENCES Prod_Familias_Salas (Id_Prod_Familia_Sala)
GO

/*======================================================================================================================*/

ALTER TABLE Contratos_Prod ADD Id_Prod_Familia_Sala INT
GO

ALTER TABLE Contratos_Prod ADD CONSTRAINT FK_ContP_Prod_Familias_Salas FOREIGN KEY (Id_Prod_Familia_Sala) REFERENCES Prod_Familias_Salas (Id_Prod_Familia_Sala)
GO

/*======================================================================================================================*/

CREATE TABLE Contratos_Prod_Horarios
(
Id_Contrato_Prod_Horario	INT IDENTITY(1,1),
Id_Contrato					INT NOT NULL,
Item						SMALLINT NOT NULL,
Id_Prod_Familia_Horario		INT NOT NULL
)
GO

ALTER TABLE Contratos_Prod_Horarios ADD CONSTRAINT PK_CONPROHOR_PorId PRIMARY KEY (Id_Contrato_Prod_Horario)
GO

CREATE UNIQUE INDEX IX_CONPROHOR_PorId_Contrato_Horario ON Contratos_Prod_Horarios (Id_Contrato, Item, Id_Prod_Familia_Horario)
GO

ALTER TABLE Contratos_Prod_Horarios ADD CONSTRAINT FK_CONPROHOR_Contratos_Prod FOREIGN KEY (Id_Contrato, Item) REFERENCES Contratos_Prod (Id_Contrato, Item)
GO

ALTER TABLE Contratos_Prod_Horarios ADD CONSTRAINT FK_CONPROHOR_Prod_Familias_Horarios FOREIGN KEY (Id_Prod_Familia_Horario) REFERENCES Prod_Familias_Horarios (Id_Prod_Familia_Horario)
GO